<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="header">
	<h1><?php echo $current_user['user_login'] ?></h1>
	<div class="skill-rating">
		<div class="skill">
			<div>
				<?php echo get_lang('user/skill') ?><br />
				<span class="number"><?php echo $current_user['user_skill'] ?></span>
			</div>
		</div>
		<div class="rating">
			<?php if ($allow_vote): ?><a href="/vote/user/positive/<?php echo $current_user['user_id'] ?>" class="vote-plus"></a><?php endif ?>
			<div>
				<?php echo get_lang('user/rating') ?><br />
				<span class="number"><?php echo $current_user['user_rating'] ?></span><br />
				<?php echo get_lang('vote/count', $current_user['user_count_vote'], declension($current_user['user_count_vote'], get_lang('vote/count_declensions'))) ?>
			</div>
			<?php if ($allow_vote): ?><a href="/vote/user/negative/<?php echo $current_user['user_id'] ?>" class="vote-minus"></a><?php endif ?>
		</div>
	</div>
</div>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td><div><a href="/profile/<?php echo $current_user['user_login'] ?>"><?php echo get_lang('profile') ?></a></div></td>
			<td><div><a href="/friends/<?php echo $current_user['user_id'] ?>"><?php echo get_lang('friends') ?></a></div></td>
			<td><div><a href="/personal/<?php echo $current_user['user_login'] ?>"><?php echo get_lang('blog') ?></a></div></td>
			<td class="current"><div><a href="/comments/user/<?php echo $current_user['user_id'] ?>"><?php echo get_lang('comments') ?> (<?php echo $current_user['user_count_comments'] ?>)</a></div></td>
		</tr>
	</table>
</div>

<div class="content">
	<?php foreach ($comments_array as $fields): ?>
		<div class="comment">
			<div class="meta">
				<div class="user"><a href="/profile/<?php echo $current_user['user_login'] ?>"><?php echo $current_user['user_login'] ?></a></div>
				<div class="date"><?php echo fdate($fields['comment_time']) ?></div>
				
				<ul class="options">
					<li><a href="/comment/<?php echo $fields['comment_id'] ?>" title="<?php echo get_lang('comments/comment_link') ?>">#</a></li>
				</ul>
				
				<div class="post-info">
					<a class="blog" href="<?php echo $fields['blog_link'] ?>"><?php echo $fields['blog_url'] ? $fields['blog_name'] : get_lang('main/blog_personal', $fields['user_login']) ?></a> / 
					<a class="post" href="<?php echo $fields['post_link'] ?>"><?php echo $fields['post_title'] ?></a>
				</div>
				
				<ul class="vote<?php echo $fields['comment_positive'] ? ' positive' : ($fields['comment_negative'] ? ' negative' : '') ?>">
					<li><?php echo ($fields['comment_rating'] > 0 ? '+' : '') . $fields['comment_rating'] ?></li>
					<?php if ($fields['allow_vote']): ?>
						<li class="buttons">
							<a href="/vote/comment/negative/<?php echo $fields['comment_id'] ?>" class="vote_minus" title="<?php echo get_lang('comments/comment_bad') ?>"></a>
							<a href="/vote/comment/positive/<?php echo $fields['comment_id'] ?>" class="vote_plus" title="<?php echo get_lang('comments/comment_good') ?>"></a>
						</li>
					<?php endif ?>
				</ul>
			</div>
			
			<div class="text">
				<?php echo tags($fields['comment_text']) ?>
			</div>
		</div>
	<?php endforeach ?>
</div>

<?php view_include('pagination') ?>