<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li class="current"><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="header">
	<h1><?php echo $blog_data['blog_name'] ?></h1>
	<div class="skill-rating">
		<div class="rating">
			<?php if ($allow_vote): ?>
				<a href="/vote/blog/positive/<?php echo $blog_data['blog_id'] ?>" class="vote-plus"></a>
			<?php endif ?>
			<div>
				<?php echo get_lang('vote/rating') ?><br />
				<span class="number"><?php echo $blog_data['blog_rating'] ?></span><br />
				<?php echo get_lang('vote/count', $blog_data['blog_count_vote'], declension($blog_data['blog_count_vote'], get_lang('vote/count_declensions'))) ?>
			</div>
			<?php if ($allow_vote): ?>
				<a href="/vote/blog/negative/<?php echo $blog_data['blog_id'] ?>" class="vote-minus"></a>
			<?php endif ?>
		</div>
	</div>
</div>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td><div><a href="/blog/<?php echo $blog_data['blog_url'] ?>"><?php echo get_lang('blog/info') ?></a></div></td>
			<td><div><a href="/blogs/<?php echo $blog_data['blog_url'] ?>"><?php echo get_lang('blog/posts') ?></a></div></td>
			<td class="current"><div><a href="/blog/users/<?php echo $blog_data['blog_url'] ?>"><?php echo get_lang('blog/users') ?> (<?php echo $blog_data['blog_count_users'] ?>)</a></div></td>
			<?php if($blog_data['blog_count_entries']): ?>
				<td><div><a href="/blog/entries/<?php echo $blog_data['blog_url'] ?>"><?php echo get_lang('blog/users_entries') ?> (<?php echo $blog_data['blog_count_entries'] ?>)</a></div></td>
			<?php endif ?>
			</tr>
	</table>
</div>

<form action="/blog/users/<?php echo $blog_data['blog_url'] ?>" name="delete_form" method="post">
	<div class="live">
		<div class="br">
		<div class="bl">
		<div class="tr">
		<div class="text">
			<table>
				<tr>
					<td width="5%"><input type="checkbox" id="set" onclick="setAllCheckboxesRange('delete_form', 'id', 'set');  return false;" /></td>
					<th width="45%"></th>
					<th width="20%"></th>
					<th width="15%"><?php echo get_lang('user/skill') ?></th>
					<th width="15%"><?php echo get_lang('user/rating') ?></th>
				</tr>
				
				<?php $i = 1; foreach ($users_array as $fields): ?>
				<tr>
					<td>
						<input type="checkbox" id="id<?php echo $i++ ?>" name="users[]"  value="<?php echo $fields['user_id'] ?>" />
					</td>
					
					<td>
						<a href="/profile/<?php echo $fields['user_login'] ?>"><?php echo $fields['user_login'] ?></a>
					</td>
					
					<td>
						<?php user_online($fields['user_id']) == USER_ONLINE && print(get_lang('user/online')) ?>
					</td>
					
					<td class="skill" style="text-align: center;">
						<span class="number"><?php echo $fields['user_skill'] ?></span>
					</td>
					
					<td class="rating" style="text-align: center;">
						<span class="number"><?php echo $fields['user_rating'] ?></span>
					</td>
				</tr>
				<?php endforeach; ?>
			</table>
		</div>
		</div>
		</div>
		</div>
	</div>
	
	<?php view_include('pagination') ?>
	
	<div  style="float: right;">
		<input type="submit" name="delete" value="<?php echo get_lang('blog/users_delete_checked') ?>" />
	</div>
</form>