<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li class="current"><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="header">
	<h1><?php echo $blog_data['blog_name'] ?></h1>
	<div class="skill-rating">
		<div class="rating">
			<?php if ($allow_vote): ?>
				<a href="/vote/blog/positive/<?php echo $blog_data['blog_id'] ?>" class="vote-plus"></a>
			<?php endif ?>
			<div>
				<?php echo get_lang('vote/rating') ?><br />
				<span class="number"><?php echo $blog_data['blog_rating'] ?></span><br />
				<?php echo get_lang('vote/count', $blog_data['blog_count_vote'], declension($blog_data['blog_count_vote'], get_lang('vote/count_declensions'))) ?>
			</div>
			<?php if ($allow_vote): ?>
				<a href="/vote/blog/negative/<?php echo $blog_data['blog_id'] ?>" class="vote-minus"></a>
			<?php endif ?>
		</div>
	</div>
</div>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td class="current"><div><a href="/blog/<?php echo $blog_data['blog_url'] ?>"><?php echo get_lang('blog/info') ?></a></div></td>
			<?php if (is_admin()): ?>
				<td><div><a href="/blog/edit/<?php echo $blog_data['blog_url'] ?>"><?php echo get_lang('blog/edit_submit') ?></a></div></td>
			<?php endif ?>
			<td><div><a href="/blogs/<?php echo $blog_data['blog_url'] ?>"><?php echo get_lang('blog/posts') ?></a></div></td>
			<td><div><a href="/blog/users/<?php echo $blog_data['blog_url'] ?>"><?php echo get_lang('blog/users') ?> (<?php echo $blog_data['blog_count_users'] ?>)</a></div></td>
			<?php if($blog_data['blog_count_entries']): ?>
				<td><div><a href="/blog/entries/<?php echo $blog_data['blog_url'] ?>"><?php echo get_lang('blog/users_entries') ?> (<?php echo $blog_data['blog_count_entries'] ?>)</a></div></td>
			<?php endif ?>
			</tr>
	</table>
</div>

<div class="content">
	<div class="card">
		<?php if ($blog_data['blog_description']): ?>
			<dl>
				<dt><?php echo get_lang('blog/description') ?>:</dt>
				<dd><?php echo tags($blog_data['blog_description']) ?></dd>
			</dl>
		<?php endif ?>
		
		<dl>
			<dt><?php echo get_lang('blog/add_time') ?>:</dt>
			<dd><?php echo fdate($blog_data['blog_add_time']) ?></dd>
		</dl>
		
		<dl class="list">
			<dt>
				<?php if (is_admin()): ?>
					<a href="/access/blogs/<?php echo $blog_data['blog_id'] ?>"><?php echo get_lang('blog/moderators') ?></a>
				<?php else: ?>
					<?php echo get_lang('blog/moderators') ?>
				<?php endif ?>:
				</dt>
			<dd>
				<ul>
					<?php if (count($moderators_users) or count($moderators_groups)): ?>
						<?php foreach ($moderators_groups as $group): ?>
							<li><a class="group" href="/group/<?php echo $group['group_id'] ?>"><?php echo $group['group_name'] ?></a></li>
						<?php endforeach ?>
						
						<?php foreach ($moderators_users as $user): ?>
							<li><a class="user" href="/profile/<?php echo $user['user_login'] ?>"><?php echo $user['user_login'] ?></a></li>
						<?php endforeach ?>
					<?php else: ?>
						<?php echo get_lang('no') ?>
					<?php endif ?>
				</ul>
			</dd>
		</dl>
		
		<?php if (array_sum($blog_ship)): ?>
			<dl>
				<dt></dt>
				<dd>
					<?php if ($blog_ship['ship']): ?>
						<a href="/blog/ship/<?php echo $blog_data['blog_url'] ?>"><?php echo get_lang('blog/ship') ?></a>
					<?php elseif ($blog_ship['unship']): ?>
						<a href="/blog/unship/<?php echo $blog_data['blog_url'] ?>"><?php echo get_lang('blog/unship') ?></a>
					<?php endif ?>
				</dd>
			</dl>
		<?php endif ?>
	</div>
</div>