<ul class="panel-nav-top">
	<li><a href="/"><?php echo get_lang('posts') ?></a></li>
	<li><a href="/blogs/list"><?php echo get_lang('blogs') ?></a></li>
	<li><a href="/groups"><?php echo get_lang('groups') ?></a></li>
	<li><a href="/users"><?php echo get_lang('users') ?></a></li>
</ul>

<div class="page-navigation">
	<table class="page-menu">
		<tr>
			<td><div><a href="/access/personal"><?php echo get_lang('access/moderators') ?></a></div></td>
			<td class="current"><div><a href="/access/personal/add"><?php echo get_lang('access/add_submit') ?></a></div></td>
		</tr>
	</table>
</div>

<div class="content">
	<div class="card">
		<form action="/access/personal/add" method="post">
			<?php if ($user_error): ?>
				<dl>
					<dt></dt>
					<dd><?php echo get_lang('access/user_error') ?></dd>
				</dl>
			<?php endif ?>
			
			<dl>
				<dt><?php echo get_lang('group') ?>:</dt>
				<dd>
					<select name="group">
						<option value="0"><?php echo get_lang('select') ?></option>
						<?php foreach ($groups_array as $fields): ?>
							<option value="<?php echo $fields['group_id'] ?>"><?php echo $fields['group_name'] ?></option>
						<?php endforeach ?>
					</select>
				</dd>
			</dl>
			
			<dl>
				<dt><?php echo get_lang('user') ?>:</dt>
				<dd><input type="text" name="user" value="" /></dd>
			</dl>
			
			<dl>
				<dt><?php echo get_lang('access/access') ?>:</dt>
				<dd>
					<input type="checkbox" name="view_post" value="1" /> <?php echo get_lang('access/view_post') ?><br />
					<input type="checkbox" name="edit_post" value="1" /> <?php echo get_lang('access/edit_post') ?><br />
					<input type="checkbox" name="delete_post" value="1" /> <?php echo get_lang('access/delete_post') ?><br />
					<input type="checkbox" name="edit_comment" value="1" /> <?php echo get_lang('access/edit_comment') ?><br />
					<input type="checkbox" name="delete_comment" value="1" /> <?php echo get_lang('access/delete_comment') ?>
				</dd>
			</dl>
			
			<dl>
				<dt></dt>
				<dd><input type="submit" value="<?php echo get_lang('access/add_submit') ?>" /></dd>
			</dl>
		</form>
	</div>
</div>