<?php
/**
 * Скрипт поиска музыки.
 * Ищет с ресурса Вконтате. 
 *
 * Автор: ofroke 
 * ICQ: 531103
 * 
 * Скрипт написан на PHP с использованием MySQL. 
 * Высокая скорость работы скрипта, мизерная нагрузка.
 * Полная поддержка по скрипту.
 *
 * Все права защищены © 2010 - 2011
 */
 
class index extends controller {
	
	var $error;
	
	function __construct($registry) {
		parent::__construct($registry);
		
		$this->error = $this->registry->get('error');
		
	}
	
	function title() {
		return 'Поиск музыки. ';
	}
	
	function keywords() {
		return 'скачать музыку, поиск музыки, скачать mp3, бесплатные mp3, новые mp3, mp3 скачать без регистрации, mp3 скачать бесплатно';
	}
	
	function content() {
		
		echo '<div class="block">Поиск музыки </div>'.($this->error ? '<div class="error">'.$this->error.'</div>' : '').'
		<div class="line">
		<form action="'.URL.'search/" method="get">
		Исполнитель или название песни: <br/>
		<input type="text" name="query" value="" /> <br/>
		Сортировать: <br/> 
		<select name="sort"> 
		<option value="0">по длительности</option>
		<option value="1">по дате добавления</option>
		</select> <br/> 

		<input type="checkbox" name="lyrics" value="1" /> Поиск с текстом <br/>
		<input type="checkbox" name="duration" value="1" checked="checked"/> Показывать длителность<br/>
		<input type="submit" value="Найти" />
		</form>
		</div>
		<div class="block">Последние запросы</div>
		<div class="line">';
		
		$sql = $this->db->query("SELECT * FROM `".SEARCH."` ORDER BY `data` DESC LIMIT " . SEARCH_COUNT);
		
		if($this->db->num_rows($sql)) {
		
			while($row = $this->db->fetch_assoc($sql)) 
				echo '&raquo; <a href="'.URL.'search/?query='.rawurlencode($row['value']).'&amp;duration=1&amp;sort=0">'.$row['value'].'</a> <span class="gr" style="font-size: x-small;">('.date('h:i', $row['data']).')</span> <br/>';
			
		} else
			echo 'За все время никто не воспользовался сервисом';
		echo '</div>

		<div class="block">Исполнители по алфавиту</div>
		<div class="line">
		<img src="'.STYLE.'images/rus.gif" alt="RUS" /> ';
		
		foreach(array('А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Э', 'Ю', 'Я', '0-9') AS $value) 
			echo '<a href="'.URL.'artists/?letter='.rawurlencode($value).'">'.$value.'</a> ';
			
		echo ' <br/>
		<img src="'.STYLE.'images/eng.gif" alt="RUS" /> ';
		
		foreach(range('A', 'Z') AS $value) 
			echo '<a href="'.URL.'artists/?letter='.rawurlencode($value).'">'.$value.'</a> ';

		echo '</div> <div class="block">Мнения</div>';
		
		$sql = $this->db->query("SELECT * FROM `".COMMENTS."` ORDER BY `data` DESC LIMIT ".COMMENTS_COUNT);
		
		if($this->db->num_rows($sql)) {

			$i = 0;
			while($row = $this->db->fetch_assoc($sql)) 
				echo '<div class="'.($i++ % 2 ? 'line' : 'line2').'">
				<b>'.xss($row['name']).'</b> <span class="gr" style="font-size: x-small;">('.main::time($row['data']).')</span> <br/> 
				'.xss($row['text']).' <br/> 
				<span class="gr" style="font-size: x-small;">IP: '.long2ip($row['ip']).'| UA: '.xss($row['ua']).'</span></div>';
			
			echo '<div class="line"><a href="'.URL.'comments/" style="font-weight: bold;">Показать все&gt;&gt;</a></div>';
			
		} else 
			echo '<div class="line">Нет ни одного мнения о сервисе.  <a href="'.URL.'comments/">Добавить</a></div>';
		
	}


}







?>