<?php
/**
 * Скрипт поиска музыки.
 * Ищет с ресурса Вконтате. 
 *
 * Автор: ofroke 
 * ICQ: 531103
 * 
 * Скрипт написан на PHP с использованием MySQL. 
 * Высокая скорость работы скрипта, мизерная нагрузка.
 * Полная поддержка по скрипту.
 *
 * Все права защищены © 2010 - 2011
 */
 
define('ROOT', str_replace('\\', '/', getcwd()) . '/');

if(file_exists(ROOT . 'incfiles/core.php')) 
	require_once (ROOT . 'incfiles/core.php');
else
	die ('Ошибка подключения системного файла');

	
$module = 'index';
$error = $route = NULL;

if(!empty($_GET['route'])) {

	$route = explode("/", $_GET['route']);
	
	if(isset($route[0], $_GET['sort']) && $route[0] == 'search')
		$module = 'search';
	
	elseif(isset($route[0], $route[1]) && $route[0] == 'track' && !empty($route[1])) 
		$module = preg_match('|(\d+);([\d\-]+)|', @base64_decode($route[1])) ? 'track' : 'index';

	elseif(isset($route[0], $route[1]) && $route[0] == 'lyrics' && is_numeric($route[1])) {
		$module = 'lyrics';
		$registry -> set('lyrics_id', $route[1]);
		
	} elseif(isset($route[0]) && $route[0] == 'artists') 
		$module = 'artists';
		
	elseif(isset($route[0]) && $route[0] == 'comments')
		$module = 'comments';
		
	if(isset($_GET['query'])) {
	
		if(empty($_GET['query']))
			$error = 'Пожалуйста, введите исполнителя или название песни';
		
		elseif(mb_strlen($_GET['query']) > 30)
			$error = 'Слишком длинный запрос';
		
		elseif(isset($_GET['no_result']))
			$error = 'Запрос недал результатов';
	}
	
}

if($error)
	$module = 'index';
	
$registry -> set('error', $error);
$registry -> set('route', $route);

$obj = new $module($registry);

header("Content-type: application/xhtml+xml; charset=utf-8");
header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");
header("Cache-Control: no-cache, must-relative");
 
echo '<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//WAPFORUM//DTD XHTML Mobile 1.0//EN" 
"http://www.wapforum.org/DTD/xhtml-mobile10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ru">
<head>
	<meta http-equiv="pragma" content="no-cache" />
	<meta http-equiv="cache-control" content="no-cache" />
	<meta http-equiv="Content-type" content="application/xhtml+xml; charset=UTF-8" />
	<meta name="keywords" content="'.$obj->keywords().'" />					
	<title>'.$obj->title().'</title>   
	<link rel="stylesheet" href="http://k-wap.ru/style/style.css" type="text/css" />   
</head>
<body>
<div class="title" style="text-align:center;"><b>K-WAP.RU</b> Лучшая Эротика</div>';

ob_start('tab_replace');

if($module == 'search' or $module == 'lyrics') {

	$cache = new File_Cache('data');

	if($get = $cache->get($_SERVER['REQUEST_URI']))
		echo $get;
	else {

		$obj->content();
		$s = ob_get_contents();
		ob_end_flush();
		$cache->set($_SERVER['REQUEST_URI'], $s);

	}

} else {
	$obj->content();
	ob_end_flush();
}

echo '<div class="foot" title="ICQ#: 53-11-03">(c) Created by <a href="/">ofroke</a> :) <a href="http://waplog.net/c.shtml?170703"><img src="http://c.waplog.net/170703.cnt" alt="waplog" style="float: right;"/></a> </div>
<div class="line">
</div>
</body></html> ';

?>