# `mobicms/render`

This package is part of [mobiCMS](https://github.com/mobicms/mobicms) and [JohnCMS](https://github.com/simba77/johncms),
but can be used freely in any other projects.

[![GitHub](https://img.shields.io/github/license/mobicms/render?color=green)](https://github.com/mobicms/render/blob/develop/LICENSE)
[![GitHub release (latest SemVer)](https://img.shields.io/github/v/release/mobicms/render)](https://github.com/mobicms/render/releases)
[![Packagist](https://img.shields.io/packagist/dt/mobicms/render)](https://packagist.org/packages/mobicms/render)

[![CI-Analysis](https://github.com/mobicms/render/workflows/Analysis/badge.svg)](https://github.com/mobicms/render/actions?query=workflow%3AAnalysis)
[![CI-Tests](https://github.com/mobicms/render/workflows/Tests/badge.svg)](https://github.com/mobicms/render/actions?query=workflow%3ATests)
[![Code Coverage](https://scrutinizer-ci.com/g/mobicms/render/badges/coverage.png)](https://scrutinizer-ci.com/g/mobicms/render/code-structure/develop/code-coverage)
[![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/mobicms/render/badges/quality-score.png)](https://scrutinizer-ci.com/g/mobicms/render)

[![YAGNI](https://img.shields.io/badge/principle-YAGNI-blueviolet.svg)](https://en.wikipedia.org/wiki/YAGNI)
[![KISS](https://img.shields.io/badge/principle-KISS-blueviolet.svg)](https://en.wikipedia.org/wiki/KISS_principle)

**mobicms/render is a native PHP template system** that started on the basis of [league/plates v.3.3.0](https://github.com/thephpleague/plates/releases/tag/3.3.0).
The development of the original package went in a direction that was not suitable for our projects where Plates was used, so it was decided to continue development as an independent package.
Our goal was to simplify the source code as much as possible, get rid of the unnecessary and add the missing functionality.

  
## Installation

The preferred method of installation is via [Composer](http://getcomposer.org). Run the following
command to install the package and add it as a requirement to your project's
`composer.json`:

```bash
composer require mobicms/render
```


## Documentation

Check out the [documentation wiki](https://github.com/mobicms/render/wiki) for detailed information
and code examples.


## Contributing

Contributions are welcome! Please read [CONTRIBUTING](https://github.com/mobicms/render/blob/develop/.github/CONTRIBUTING.md) for details.  

This project adheres to a [Contributor Code of Conduct](https://github.com/mobicms/render/blob/develop/.github/CODE_OF_CONDUCT.md).
By participating in this project and its community, you are expected to uphold this code.

In our development, we follow the principles of [YAGNI](https://en.wikipedia.org/wiki/YAGNI) and [KISS](https://en.wikipedia.org/wiki/KISS_principle).  
The source code should not have extra unnecessary functionality and should be as simple and efficient as possible.


## License

The `mobicms/render` library is licensed for use under the MIT License (MIT).  
Please see [LICENSE](https://github.com/mobicms/render/blob/master/LICENSE) for more information.


## Our links
- [**mobiCMS Project**](https://mobicms.org) website and support forum
- [**Facebook**](https://www.facebook.com/mobicms)
- [**Twitter**](https://twitter.com/mobicms)
